<?php

namespace App\Controller;

use App\Entity\Booking;
use App\Form\BookingType;
use App\Repository\ServiceProviderRepository;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

class ServiceProviderController extends AbstractController
{
    #[Route('/services', name: 'app_services')]
    public function list(
        Request $request,
        ServiceProviderRepository $serviceProviderRepository,
        PaginatorInterface $paginator
    ): Response {
        $query = $serviceProviderRepository->createQueryBuilder('sp')
            ->where('sp.isAvailable = :available')
            ->setParameter('available', true)
            ->orderBy('sp.rating', 'DESC')
            ->getQuery();

        $pagination = $paginator->paginate(
            $query,
            $request->query->getInt('page', 1),
            9
        );

        return $this->render('service_provider/list.html.twig', [
            'serviceProviders' => $pagination,
        ]);
    }

    #[Route('/staff/{id}', name: 'app_staff_detail', requirements: ['id' => '\d+'])]
    public function detail(int $id, ServiceProviderRepository $serviceProviderRepository): Response
    {
        $serviceProvider = $serviceProviderRepository->findOneWithDetails($id);

        if (!$serviceProvider) {
            throw $this->createNotFoundException('Service provider not found');
        }

        $booking = new Booking();
        $booking->setServiceProvider($serviceProvider);

        $form = $this->createForm(BookingType::class, $booking);

        return $this->render('service_provider/detail.html.twig', [
            'serviceProvider' => $serviceProvider,
            'form' => $form,
        ]);
    }
}
