<?php

namespace App\Form;

use App\Entity\ServiceProvider;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TelType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints as Assert;

class AdminServiceProviderType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('email', EmailType::class, [
                'label' => 'Email Address',
                'mapped' => false,
                'constraints' => [
                    new Assert\NotBlank(),
                    new Assert\Email(),
                ],
                'attr' => ['placeholder' => 'provider@example.com']
            ])
            ->add('firstName', TextType::class, [
                'label' => 'First Name',
                'mapped' => false,
                'constraints' => [
                    new Assert\NotBlank(),
                ],
                'attr' => ['placeholder' => 'First name']
            ])
            ->add('lastName', TextType::class, [
                'label' => 'Last Name',
                'mapped' => false,
                'constraints' => [
                    new Assert\NotBlank(),
                ],
                'attr' => ['placeholder' => 'Last name']
            ])
            ->add('phone', TelType::class, [
                'label' => 'Phone Number',
                'mapped' => false,
                'required' => false,
                'attr' => ['placeholder' => '(555) 123-4567']
            ])
            ->add('bio', TextareaType::class, [
                'label' => 'Bio / About',
                'required' => false,
                'attr' => [
                    'rows' => 4,
                    'placeholder' => 'Professional background and expertise...'
                ]
            ])
            ->add('yearsOfExperience', NumberType::class, [
                'label' => 'Years of Experience',
                'attr' => [
                    'min' => 0,
                    'max' => 50,
                    'placeholder' => '5'
                ]
            ])
            ->add('hourlyRate', MoneyType::class, [
                'label' => 'Hourly Rate',
                'currency' => 'USD',
                'attr' => ['placeholder' => '35.00']
            ])
            ->add('isAvailable', CheckboxType::class, [
                'label' => 'Available for Bookings',
                'required' => false,
            ])
            ->add('isVerified', CheckboxType::class, [
                'label' => 'Verified Provider',
                'required' => false,
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => ServiceProvider::class,
        ]);
    }
}
