<?php

namespace App\Form;

use App\Entity\Booking;
use App\Entity\Service;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TelType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TimeType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class BookingType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('customerName', TextType::class, [
                'label' => 'Your Name',
                'attr' => [
                    'placeholder' => 'Enter your full name'
                ]
            ])
            ->add('customerEmail', EmailType::class, [
                'label' => 'Email Address',
                'attr' => [
                    'placeholder' => 'your.email@example.com'
                ]
            ])
            ->add('customerPhone', TelType::class, [
                'label' => 'Phone Number',
                'attr' => [
                    'placeholder' => '(555) 123-4567'
                ]
            ])
            ->add('service', EntityType::class, [
                'class' => Service::class,
                'choice_label' => 'name',
                'label' => 'Select Service',
                'placeholder' => 'Choose a service...',
                'query_builder' => function ($repository) {
                    return $repository->createQueryBuilder('s')
                        ->where('s.isActive = :active')
                        ->setParameter('active', true)
                        ->orderBy('s.name', 'ASC');
                }
            ])
            ->add('serviceDate', DateType::class, [
                'label' => 'Preferred Date',
                'widget' => 'single_text',
                'html5' => true,
            ])
            ->add('serviceTime', TimeType::class, [
                'label' => 'Preferred Time',
                'widget' => 'single_text',
                'html5' => true,
            ])
            ->add('hours', ChoiceType::class, [
                'label' => 'Number of Hours',
                'choices' => [
                    '2 hours' => 2,
                    '3 hours' => 3,
                    '4 hours' => 4,
                    '5 hours' => 5,
                    '6 hours' => 6,
                    '8 hours' => 8,
                ],
                'placeholder' => 'Select hours...',
            ])
            ->add('serviceAddress', TextareaType::class, [
                'label' => 'Service Address',
                'attr' => [
                    'rows' => 3,
                    'placeholder' => 'Enter complete address'
                ]
            ])
            ->add('specialInstructions', TextareaType::class, [
                'label' => 'Special Instructions',
                'required' => false,
                'attr' => [
                    'rows' => 4,
                    'placeholder' => 'Any specific requirements or instructions...'
                ]
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Booking::class,
        ]);
    }
}
