<?php

namespace App\Form;

use App\Entity\ServiceProvider;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TelType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ServiceProviderProfileType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('bio', TextareaType::class, [
                'label' => 'About You',
                'required' => false,
                'attr' => [
                    'rows' => 5,
                    'placeholder' => 'Tell clients about your experience, expertise, and approach to household services...'
                ],
                'help' => 'This will be displayed on your public profile'
            ])
            ->add('yearsOfExperience', NumberType::class, [
                'label' => 'Years of Experience',
                'attr' => [
                    'min' => 0,
                    'max' => 50,
                    'placeholder' => 'e.g., 5'
                ]
            ])
            ->add('hourlyRate', MoneyType::class, [
                'label' => 'Hourly Rate',
                'currency' => 'USD',
                'attr' => [
                    'placeholder' => '35.00'
                ],
                'help' => 'Your rate per hour in USD'
            ])
            ->add('bufferTime', ChoiceType::class, [
                'label' => 'Travel/Preparation Time',
                'choices' => [
                    '15 minutes' => 15,
                    '30 minutes' => 30,
                    '45 minutes' => 45,
                    '1 hour' => 60,
                    '1.5 hours' => 90,
                    '2 hours' => 120,
                ],
                'help' => 'Time needed between bookings for travel and preparation'
            ])
        ;

        // Add user fields
        if ($options['include_user_fields']) {
            $builder
                ->add('firstName', TextType::class, [
                    'label' => 'First Name',
                    'mapped' => false,
                    'attr' => ['placeholder' => 'Your first name']
                ])
                ->add('lastName', TextType::class, [
                    'label' => 'Last Name',
                    'mapped' => false,
                    'attr' => ['placeholder' => 'Your last name']
                ])
                ->add('phone', TelType::class, [
                    'label' => 'Phone Number',
                    'mapped' => false,
                    'required' => false,
                    'attr' => ['placeholder' => '(555) 123-4567']
                ])
            ;
        }
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => ServiceProvider::class,
            'include_user_fields' => true,
        ]);
    }
}
