<?php

namespace App\Repository;

use App\Entity\Booking;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Booking>
 */
class BookingRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Booking::class);
    }

    /**
     * Find all bookings with related data (for admin)
     */
    public function findAllWithDetails(): array
    {
        return $this->createQueryBuilder('b')
            ->leftJoin('b.serviceProvider', 'sp')->addSelect('sp')
            ->leftJoin('sp.user', 'u')->addSelect('u')
            ->leftJoin('b.service', 's')->addSelect('s')
            ->orderBy('b.createdAt', 'DESC')
            ->getQuery()
            ->getResult();
    }

    /**
     * Find bookings by service provider
     */
    public function findByServiceProvider(int $serviceProviderId): array
    {
        return $this->createQueryBuilder('b')
            ->leftJoin('b.service', 's')->addSelect('s')
            ->where('b.serviceProvider = :providerId')
            ->setParameter('providerId', $serviceProviderId)
            ->orderBy('b.serviceDate', 'DESC')
            ->addOrderBy('b.serviceTime', 'DESC')
            ->getQuery()
            ->getResult();
    }

    /**
     * Find pending bookings
     */
    public function findPending(): array
    {
        return $this->createQueryBuilder('b')
            ->leftJoin('b.serviceProvider', 'sp')->addSelect('sp')
            ->leftJoin('sp.user', 'u')->addSelect('u')
            ->leftJoin('b.service', 's')->addSelect('s')
            ->where('b.status = :status')
            ->setParameter('status', Booking::STATUS_PENDING)
            ->orderBy('b.createdAt', 'ASC')
            ->getQuery()
            ->getResult();
    }
}
