<?php

namespace App\Repository;

use App\Entity\Review;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Review>
 */
class ReviewRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Review::class);
    }

    /**
     * Find approved reviews for a service provider
     */
    public function findApprovedByServiceProvider(int $serviceProviderId, int $limit = 10): array
    {
        return $this->createQueryBuilder('r')
            ->where('r.serviceProvider = :providerId')
            ->andWhere('r.isApproved = :approved')
            ->setParameter('providerId', $serviceProviderId)
            ->setParameter('approved', true)
            ->orderBy('r.createdAt', 'DESC')
            ->setMaxResults($limit)
            ->getQuery()
            ->getResult();
    }
}
