<?php

namespace App\Repository;

use App\Entity\ServiceProvider;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<ServiceProvider>
 */
class ServiceProviderRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ServiceProvider::class);
    }

    /**
     * Find all available service providers with their services
     */
    public function findAllAvailable(): array
    {
        return $this->createQueryBuilder('sp')
            ->leftJoin('sp.user', 'u')
            ->leftJoin('sp.serviceProviderServices', 'sps')
            ->leftJoin('sps.service', 's')
            ->where('sp.isAvailable = :available')
            ->andWhere('u.isActive = :active')
            ->setParameter('available', true)
            ->setParameter('active', true)
            ->orderBy('sp.rating', 'DESC')
            ->addOrderBy('sp.totalReviews', 'DESC')
            ->getQuery()
            ->getResult();
    }

    /**
     * Find service provider by ID with all relations
     */
    public function findOneWithDetails(int $id): ?ServiceProvider
    {
        return $this->createQueryBuilder('sp')
            ->leftJoin('sp.user', 'u')->addSelect('u')
            ->leftJoin('sp.serviceProviderServices', 'sps')->addSelect('sps')
            ->leftJoin('sps.service', 's')->addSelect('s')
            ->leftJoin('sp.reviews', 'r')->addSelect('r')
            ->where('sp.id = :id')
            ->andWhere('r.isApproved = :approved OR r.id IS NULL')
            ->setParameter('id', $id)
            ->setParameter('approved', true)
            ->orderBy('r.createdAt', 'DESC')
            ->getQuery()
            ->getOneOrNullResult();
    }
}
