<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* provider/bookings.html.twig */
class __TwigTemplate_bd2589ca86455e92472214d49d5a2314 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'body' => [$this, 'block_body'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "provider/bookings.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "provider/bookings.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "My Bookings - Provider Dashboard";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 5
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_body(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "body"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "body"));

        // line 6
        yield "    <section class=\"admin-header\">
        <div class=\"container\">
            <div class=\"admin-header-content\">
                <div>
                    <h1>My Bookings</h1>
                    <p>View and manage all your customer bookings</p>
                </div>
                <div class=\"admin-header-actions\">
                    <a href=\"";
        // line 14
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_provider_dashboard");
        yield "\" class=\"btn btn-secondary\">Back to Dashboard</a>
                </div>
            </div>
        </div>
    </section>

    <section class=\"admin-content\">
        <div class=\"container\">
            <div class=\"admin-grid\">
                <aside class=\"admin-sidebar\">
                    <nav class=\"admin-nav\">
                        <a href=\"";
        // line 25
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_provider_dashboard");
        yield "\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">📊</span>
                            Dashboard
                        </a>
                        <a href=\"";
        // line 29
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_provider_profile_edit");
        yield "\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">👤</span>
                            Edit Profile
                        </a>
                        <a href=\"";
        // line 33
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_provider_services_manage");
        yield "\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">🛠️</span>
                            Manage Services
                        </a>
                        <a href=\"";
        // line 37
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_provider_bookings");
        yield "\" class=\"admin-nav-item active\">
                            <span class=\"nav-icon\">📅</span>
                            My Bookings
                        </a>
                        <a href=\"";
        // line 41
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_staff_detail", ["id" => CoreExtension::getAttribute($this->env, $this->source, (isset($context["serviceProvider"]) || array_key_exists("serviceProvider", $context) ? $context["serviceProvider"] : (function () { throw new RuntimeError('Variable "serviceProvider" does not exist.', 41, $this->source); })()), "id", [], "any", false, false, false, 41)]), "html", null, true);
        yield "\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">🏠</span>
                            View Public Profile
                        </a>
                    </nav>
                </aside>

                <main class=\"admin-main\">
                    <div class=\"admin-section\">
                        <h2>All Bookings</h2>
                        ";
        // line 51
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["bookings"]) || array_key_exists("bookings", $context) ? $context["bookings"] : (function () { throw new RuntimeError('Variable "bookings" does not exist.', 51, $this->source); })())) > 0)) {
            // line 52
            yield "                            <div class=\"bookings-table\">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Date & Time</th>
                                            <th>Customer</th>
                                            <th>Contact</th>
                                            <th>Service</th>
                                            <th>Duration</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Booked On</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        ";
            // line 68
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["bookings"]) || array_key_exists("bookings", $context) ? $context["bookings"] : (function () { throw new RuntimeError('Variable "bookings" does not exist.', 68, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["booking"]) {
                // line 69
                yield "                                            <tr>
                                                <td>#";
                // line 70
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "id", [], "any", false, false, false, 70), "html", null, true);
                yield "</td>
                                                <td>
                                                    ";
                // line 72
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "serviceDate", [], "any", false, false, false, 72), "M d, Y"), "html", null, true);
                yield "<br>
                                                    <small>";
                // line 73
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "serviceTime", [], "any", false, false, false, 73), "g:i A"), "html", null, true);
                yield "</small>
                                                </td>
                                                <td>";
                // line 75
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "customerName", [], "any", false, false, false, 75), "html", null, true);
                yield "</td>
                                                <td>
                                                    <small>";
                // line 77
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "customerEmail", [], "any", false, false, false, 77), "html", null, true);
                yield "</small><br>
                                                    <small>";
                // line 78
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "customerPhone", [], "any", false, false, false, 78), "html", null, true);
                yield "</small>
                                                </td>
                                                <td>";
                // line 80
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "service", [], "any", false, false, false, 80), "name", [], "any", false, false, false, 80), "html", null, true);
                yield "</td>
                                                <td>";
                // line 81
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "hours", [], "any", false, false, false, 81), "html", null, true);
                yield " hours</td>
                                                <td><strong>\$";
                // line 82
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "totalPrice", [], "any", false, false, false, 82), "html", null, true);
                yield "</strong></td>
                                                <td>
                                                    <span class=\"badge badge-";
                // line 84
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "status", [], "any", false, false, false, 84), "html", null, true);
                yield "\">
                                                        ";
                // line 85
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::titleCase($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "status", [], "any", false, false, false, 85)), "html", null, true);
                yield "
                                                    </span>
                                                </td>
                                                <td><small>";
                // line 88
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "createdAt", [], "any", false, false, false, 88), "M d, Y"), "html", null, true);
                yield "</small></td>
                                            </tr>
                                        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['booking'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 91
            yield "                                    </tbody>
                                </table>
                            </div>
                        ";
        } else {
            // line 95
            yield "                            <div class=\"no-bookings-state\">
                                <div class=\"empty-icon\">📅</div>
                                <h3>No Bookings Yet</h3>
                                <p>Once customers book your services, they'll appear here. Make sure your profile is complete and you have services selected!</p>
                                <div class=\"empty-actions\">
                                    <a href=\"";
            // line 100
            yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_provider_services_manage");
            yield "\" class=\"btn btn-primary\">Manage Services</a>
                                    <a href=\"";
            // line 101
            yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_provider_profile_edit");
            yield "\" class=\"btn btn-secondary\">Edit Profile</a>
                                </div>
                            </div>
                        ";
        }
        // line 105
        yield "                    </div>
                </main>
            </div>
        </div>
    </section>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "provider/bookings.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  276 => 105,  269 => 101,  265 => 100,  258 => 95,  252 => 91,  243 => 88,  237 => 85,  233 => 84,  228 => 82,  224 => 81,  220 => 80,  215 => 78,  211 => 77,  206 => 75,  201 => 73,  197 => 72,  192 => 70,  189 => 69,  185 => 68,  167 => 52,  165 => 51,  152 => 41,  145 => 37,  138 => 33,  131 => 29,  124 => 25,  110 => 14,  100 => 6,  87 => 5,  64 => 3,  41 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}My Bookings - Provider Dashboard{% endblock %}

{% block body %}
    <section class=\"admin-header\">
        <div class=\"container\">
            <div class=\"admin-header-content\">
                <div>
                    <h1>My Bookings</h1>
                    <p>View and manage all your customer bookings</p>
                </div>
                <div class=\"admin-header-actions\">
                    <a href=\"{{ path('app_provider_dashboard') }}\" class=\"btn btn-secondary\">Back to Dashboard</a>
                </div>
            </div>
        </div>
    </section>

    <section class=\"admin-content\">
        <div class=\"container\">
            <div class=\"admin-grid\">
                <aside class=\"admin-sidebar\">
                    <nav class=\"admin-nav\">
                        <a href=\"{{ path('app_provider_dashboard') }}\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">📊</span>
                            Dashboard
                        </a>
                        <a href=\"{{ path('app_provider_profile_edit') }}\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">👤</span>
                            Edit Profile
                        </a>
                        <a href=\"{{ path('app_provider_services_manage') }}\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">🛠️</span>
                            Manage Services
                        </a>
                        <a href=\"{{ path('app_provider_bookings') }}\" class=\"admin-nav-item active\">
                            <span class=\"nav-icon\">📅</span>
                            My Bookings
                        </a>
                        <a href=\"{{ path('app_staff_detail', {id: serviceProvider.id}) }}\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">🏠</span>
                            View Public Profile
                        </a>
                    </nav>
                </aside>

                <main class=\"admin-main\">
                    <div class=\"admin-section\">
                        <h2>All Bookings</h2>
                        {% if bookings|length > 0 %}
                            <div class=\"bookings-table\">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Date & Time</th>
                                            <th>Customer</th>
                                            <th>Contact</th>
                                            <th>Service</th>
                                            <th>Duration</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Booked On</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {% for booking in bookings %}
                                            <tr>
                                                <td>#{{ booking.id }}</td>
                                                <td>
                                                    {{ booking.serviceDate|date('M d, Y') }}<br>
                                                    <small>{{ booking.serviceTime|date('g:i A') }}</small>
                                                </td>
                                                <td>{{ booking.customerName }}</td>
                                                <td>
                                                    <small>{{ booking.customerEmail }}</small><br>
                                                    <small>{{ booking.customerPhone }}</small>
                                                </td>
                                                <td>{{ booking.service.name }}</td>
                                                <td>{{ booking.hours }} hours</td>
                                                <td><strong>\${{ booking.totalPrice }}</strong></td>
                                                <td>
                                                    <span class=\"badge badge-{{ booking.status }}\">
                                                        {{ booking.status|title }}
                                                    </span>
                                                </td>
                                                <td><small>{{ booking.createdAt|date('M d, Y') }}</small></td>
                                            </tr>
                                        {% endfor %}
                                    </tbody>
                                </table>
                            </div>
                        {% else %}
                            <div class=\"no-bookings-state\">
                                <div class=\"empty-icon\">📅</div>
                                <h3>No Bookings Yet</h3>
                                <p>Once customers book your services, they'll appear here. Make sure your profile is complete and you have services selected!</p>
                                <div class=\"empty-actions\">
                                    <a href=\"{{ path('app_provider_services_manage') }}\" class=\"btn btn-primary\">Manage Services</a>
                                    <a href=\"{{ path('app_provider_profile_edit') }}\" class=\"btn btn-secondary\">Edit Profile</a>
                                </div>
                            </div>
                        {% endif %}
                    </div>
                </main>
            </div>
        </div>
    </section>
{% endblock %}
", "provider/bookings.html.twig", "/Users/tomasstejskal/homewifes/templates/provider/bookings.html.twig");
    }
}
