<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* admin/dashboard.html.twig */
class __TwigTemplate_452fae6696ddc645cc5e22c4727185d6 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'body' => [$this, 'block_body'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "admin/dashboard.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "admin/dashboard.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Super Admin Dashboard - HomeHelper";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 5
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_body(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "body"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "body"));

        // line 6
        yield "    <section class=\"admin-header\">
        <div class=\"container\">
            <div class=\"admin-header-content\">
                <div>
                    <h1>Super Admin Dashboard</h1>
                    <p>Manage all service providers, bookings, and platform operations</p>
                </div>
                <div class=\"admin-header-actions\">
                    <a href=\"";
        // line 14
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_home");
        yield "\" class=\"btn btn-secondary\">View Public Site</a>
                    <a href=\"";
        // line 15
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_logout");
        yield "\" class=\"btn btn-outline\">Logout</a>
                </div>
            </div>
        </div>
    </section>

    <section class=\"admin-content\">
        <div class=\"container\">
            <div class=\"admin-grid\">
                <aside class=\"admin-sidebar\">
                    <nav class=\"admin-nav\">
                        <a href=\"";
        // line 26
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_dashboard");
        yield "\" class=\"admin-nav-item active\">
                            <span class=\"nav-icon\">📊</span>
                            Dashboard
                        </a>
                        <a href=\"";
        // line 30
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_bookings");
        yield "\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">📅</span>
                            All Bookings
                        </a>
                        <a href=\"";
        // line 34
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_service_providers");
        yield "\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">👥</span>
                            Service Providers
                        </a>
                    </nav>
                </aside>

                <main class=\"admin-main\">
                    <div class=\"stats-grid\">
                        <div class=\"stat-card\">
                            <div class=\"stat-icon\">💰</div>
                            <div class=\"stat-content\">
                                <h3>\$";
        // line 46
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["stats"]) || array_key_exists("stats", $context) ? $context["stats"] : (function () { throw new RuntimeError('Variable "stats" does not exist.', 46, $this->source); })()), "total_earnings", [], "any", false, false, false, 46), "html", null, true);
        yield "</h3>
                                <p>Total Earnings</p>
                            </div>
                        </div>
                        <div class=\"stat-card\">
                            <div class=\"stat-icon\">⏳</div>
                            <div class=\"stat-content\">
                                <h3>\$";
        // line 53
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["stats"]) || array_key_exists("stats", $context) ? $context["stats"] : (function () { throw new RuntimeError('Variable "stats" does not exist.', 53, $this->source); })()), "pending_earnings", [], "any", false, false, false, 53), "html", null, true);
        yield "</h3>
                                <p>Pending Earnings</p>
                            </div>
                        </div>
                        <div class=\"stat-card\">
                            <div class=\"stat-icon\">📋</div>
                            <div class=\"stat-content\">
                                <h3>";
        // line 60
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["stats"]) || array_key_exists("stats", $context) ? $context["stats"] : (function () { throw new RuntimeError('Variable "stats" does not exist.', 60, $this->source); })()), "total_bookings", [], "any", false, false, false, 60), "html", null, true);
        yield "</h3>
                                <p>Total Bookings</p>
                            </div>
                        </div>
                        <div class=\"stat-card\">
                            <div class=\"stat-icon\">👥</div>
                            <div class=\"stat-content\">
                                <h3>";
        // line 67
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["stats"]) || array_key_exists("stats", $context) ? $context["stats"] : (function () { throw new RuntimeError('Variable "stats" does not exist.', 67, $this->source); })()), "total_service_providers", [], "any", false, false, false, 67), "html", null, true);
        yield "</h3>
                                <p>Service Providers</p>
                            </div>
                        </div>
                    </div>

                    <div class=\"admin-section\">
                        <h2>Booking Statistics</h2>
                        <div class=\"stats-row\">
                            <div class=\"stat-item\">
                                <span class=\"stat-label\">Pending:</span>
                                <span class=\"stat-value badge badge-pending\">";
        // line 78
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["stats"]) || array_key_exists("stats", $context) ? $context["stats"] : (function () { throw new RuntimeError('Variable "stats" does not exist.', 78, $this->source); })()), "pending_bookings", [], "any", false, false, false, 78), "html", null, true);
        yield "</span>
                            </div>
                            <div class=\"stat-item\">
                                <span class=\"stat-label\">Confirmed:</span>
                                <span class=\"stat-value badge badge-confirmed\">";
        // line 82
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["stats"]) || array_key_exists("stats", $context) ? $context["stats"] : (function () { throw new RuntimeError('Variable "stats" does not exist.', 82, $this->source); })()), "confirmed_bookings", [], "any", false, false, false, 82), "html", null, true);
        yield "</span>
                            </div>
                            <div class=\"stat-item\">
                                <span class=\"stat-label\">Completed:</span>
                                <span class=\"stat-value badge badge-completed\">";
        // line 86
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["stats"]) || array_key_exists("stats", $context) ? $context["stats"] : (function () { throw new RuntimeError('Variable "stats" does not exist.', 86, $this->source); })()), "completed_bookings", [], "any", false, false, false, 86), "html", null, true);
        yield "</span>
                            </div>
                            <div class=\"stat-item\">
                                <span class=\"stat-label\">Cancelled:</span>
                                <span class=\"stat-value badge badge-cancelled\">";
        // line 90
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["stats"]) || array_key_exists("stats", $context) ? $context["stats"] : (function () { throw new RuntimeError('Variable "stats" does not exist.', 90, $this->source); })()), "cancelled_bookings", [], "any", false, false, false, 90), "html", null, true);
        yield "</span>
                            </div>
                            <div class=\"stat-item\">
                                <span class=\"stat-label\">Active Providers:</span>
                                <span class=\"stat-value badge badge-success\">";
        // line 94
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["stats"]) || array_key_exists("stats", $context) ? $context["stats"] : (function () { throw new RuntimeError('Variable "stats" does not exist.', 94, $this->source); })()), "active_service_providers", [], "any", false, false, false, 94), "html", null, true);
        yield "</span>
                            </div>
                        </div>
                    </div>

                    <div class=\"admin-section\">
                        <div class=\"section-header\">
                            <h2>Recent Bookings</h2>
                            <div class=\"section-actions\">
                                <a href=\"";
        // line 103
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_booking_new");
        yield "\" class=\"btn btn-primary btn-small\">+ New Booking</a>
                                <a href=\"";
        // line 104
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_bookings");
        yield "\" class=\"btn btn-secondary btn-small\">View All</a>
                            </div>
                        </div>
                        ";
        // line 107
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), (isset($context["recentBookings"]) || array_key_exists("recentBookings", $context) ? $context["recentBookings"] : (function () { throw new RuntimeError('Variable "recentBookings" does not exist.', 107, $this->source); })())) > 0)) {
            // line 108
            yield "                            <div class=\"bookings-table\">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Date</th>
                                            <th>Customer</th>
                                            <th>Provider</th>
                                            <th>Service</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        ";
            // line 123
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["recentBookings"]) || array_key_exists("recentBookings", $context) ? $context["recentBookings"] : (function () { throw new RuntimeError('Variable "recentBookings" does not exist.', 123, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["booking"]) {
                // line 124
                yield "                                            <tr>
                                                <td>#";
                // line 125
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "id", [], "any", false, false, false, 125), "html", null, true);
                yield "</td>
                                                <td>";
                // line 126
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "serviceDate", [], "any", false, false, false, 126), "M d, Y"), "html", null, true);
                yield "</td>
                                                <td>";
                // line 127
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "customerName", [], "any", false, false, false, 127), "html", null, true);
                yield "</td>
                                                <td>";
                // line 128
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "serviceProvider", [], "any", false, false, false, 128), "user", [], "any", false, false, false, 128), "fullName", [], "any", false, false, false, 128), "html", null, true);
                yield "</td>
                                                <td>";
                // line 129
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "service", [], "any", false, false, false, 129), "name", [], "any", false, false, false, 129), "html", null, true);
                yield "</td>
                                                <td>\$";
                // line 130
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "totalPrice", [], "any", false, false, false, 130), "html", null, true);
                yield "</td>
                                                <td>
                                                    <span class=\"badge badge-";
                // line 132
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "status", [], "any", false, false, false, 132), "html", null, true);
                yield "\">
                                                        ";
                // line 133
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::titleCase($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "status", [], "any", false, false, false, 133)), "html", null, true);
                yield "
                                                    </span>
                                                </td>
                                                <td>
                                                    <a href=\"";
                // line 137
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_booking_edit", ["id" => CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "id", [], "any", false, false, false, 137)]), "html", null, true);
                yield "\" class=\"btn-table-action\">Edit</a>
                                                </td>
                                            </tr>
                                        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['booking'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 141
            yield "                                    </tbody>
                                </table>
                            </div>
                        ";
        } else {
            // line 145
            yield "                            <p class=\"no-data\">No bookings yet.</p>
                        ";
        }
        // line 147
        yield "                    </div>

                    <div class=\"admin-section\">
                        <div class=\"section-header\">
                            <h2>Quick Actions</h2>
                        </div>
                        <div class=\"quick-actions\">
                            <a href=\"";
        // line 154
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_booking_new");
        yield "\" class=\"quick-action-card\">
                                <span class=\"action-icon\">➕</span>
                                <h3>Create Booking</h3>
                                <p>Add a new customer booking</p>
                            </a>
                            <a href=\"";
        // line 159
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_service_provider_new");
        yield "\" class=\"quick-action-card\">
                                <span class=\"action-icon\">👤</span>
                                <h3>Add Provider</h3>
                                <p>Register new service provider</p>
                            </a>
                            <a href=\"";
        // line 164
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_bookings");
        yield "\" class=\"quick-action-card\">
                                <span class=\"action-icon\">📊</span>
                                <h3>View Reports</h3>
                                <p>See all bookings and earnings</p>
                            </a>
                        </div>
                    </div>
                </main>
            </div>
        </div>
    </section>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "admin/dashboard.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  358 => 164,  350 => 159,  342 => 154,  333 => 147,  329 => 145,  323 => 141,  313 => 137,  306 => 133,  302 => 132,  297 => 130,  293 => 129,  289 => 128,  285 => 127,  281 => 126,  277 => 125,  274 => 124,  270 => 123,  253 => 108,  251 => 107,  245 => 104,  241 => 103,  229 => 94,  222 => 90,  215 => 86,  208 => 82,  201 => 78,  187 => 67,  177 => 60,  167 => 53,  157 => 46,  142 => 34,  135 => 30,  128 => 26,  114 => 15,  110 => 14,  100 => 6,  87 => 5,  64 => 3,  41 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}Super Admin Dashboard - HomeHelper{% endblock %}

{% block body %}
    <section class=\"admin-header\">
        <div class=\"container\">
            <div class=\"admin-header-content\">
                <div>
                    <h1>Super Admin Dashboard</h1>
                    <p>Manage all service providers, bookings, and platform operations</p>
                </div>
                <div class=\"admin-header-actions\">
                    <a href=\"{{ path('app_home') }}\" class=\"btn btn-secondary\">View Public Site</a>
                    <a href=\"{{ path('app_logout') }}\" class=\"btn btn-outline\">Logout</a>
                </div>
            </div>
        </div>
    </section>

    <section class=\"admin-content\">
        <div class=\"container\">
            <div class=\"admin-grid\">
                <aside class=\"admin-sidebar\">
                    <nav class=\"admin-nav\">
                        <a href=\"{{ path('app_admin_dashboard') }}\" class=\"admin-nav-item active\">
                            <span class=\"nav-icon\">📊</span>
                            Dashboard
                        </a>
                        <a href=\"{{ path('app_admin_bookings') }}\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">📅</span>
                            All Bookings
                        </a>
                        <a href=\"{{ path('app_admin_service_providers') }}\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">👥</span>
                            Service Providers
                        </a>
                    </nav>
                </aside>

                <main class=\"admin-main\">
                    <div class=\"stats-grid\">
                        <div class=\"stat-card\">
                            <div class=\"stat-icon\">💰</div>
                            <div class=\"stat-content\">
                                <h3>\${{ stats.total_earnings }}</h3>
                                <p>Total Earnings</p>
                            </div>
                        </div>
                        <div class=\"stat-card\">
                            <div class=\"stat-icon\">⏳</div>
                            <div class=\"stat-content\">
                                <h3>\${{ stats.pending_earnings }}</h3>
                                <p>Pending Earnings</p>
                            </div>
                        </div>
                        <div class=\"stat-card\">
                            <div class=\"stat-icon\">📋</div>
                            <div class=\"stat-content\">
                                <h3>{{ stats.total_bookings }}</h3>
                                <p>Total Bookings</p>
                            </div>
                        </div>
                        <div class=\"stat-card\">
                            <div class=\"stat-icon\">👥</div>
                            <div class=\"stat-content\">
                                <h3>{{ stats.total_service_providers }}</h3>
                                <p>Service Providers</p>
                            </div>
                        </div>
                    </div>

                    <div class=\"admin-section\">
                        <h2>Booking Statistics</h2>
                        <div class=\"stats-row\">
                            <div class=\"stat-item\">
                                <span class=\"stat-label\">Pending:</span>
                                <span class=\"stat-value badge badge-pending\">{{ stats.pending_bookings }}</span>
                            </div>
                            <div class=\"stat-item\">
                                <span class=\"stat-label\">Confirmed:</span>
                                <span class=\"stat-value badge badge-confirmed\">{{ stats.confirmed_bookings }}</span>
                            </div>
                            <div class=\"stat-item\">
                                <span class=\"stat-label\">Completed:</span>
                                <span class=\"stat-value badge badge-completed\">{{ stats.completed_bookings }}</span>
                            </div>
                            <div class=\"stat-item\">
                                <span class=\"stat-label\">Cancelled:</span>
                                <span class=\"stat-value badge badge-cancelled\">{{ stats.cancelled_bookings }}</span>
                            </div>
                            <div class=\"stat-item\">
                                <span class=\"stat-label\">Active Providers:</span>
                                <span class=\"stat-value badge badge-success\">{{ stats.active_service_providers }}</span>
                            </div>
                        </div>
                    </div>

                    <div class=\"admin-section\">
                        <div class=\"section-header\">
                            <h2>Recent Bookings</h2>
                            <div class=\"section-actions\">
                                <a href=\"{{ path('app_admin_booking_new') }}\" class=\"btn btn-primary btn-small\">+ New Booking</a>
                                <a href=\"{{ path('app_admin_bookings') }}\" class=\"btn btn-secondary btn-small\">View All</a>
                            </div>
                        </div>
                        {% if recentBookings|length > 0 %}
                            <div class=\"bookings-table\">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Date</th>
                                            <th>Customer</th>
                                            <th>Provider</th>
                                            <th>Service</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {% for booking in recentBookings %}
                                            <tr>
                                                <td>#{{ booking.id }}</td>
                                                <td>{{ booking.serviceDate|date('M d, Y') }}</td>
                                                <td>{{ booking.customerName }}</td>
                                                <td>{{ booking.serviceProvider.user.fullName }}</td>
                                                <td>{{ booking.service.name }}</td>
                                                <td>\${{ booking.totalPrice }}</td>
                                                <td>
                                                    <span class=\"badge badge-{{ booking.status }}\">
                                                        {{ booking.status|title }}
                                                    </span>
                                                </td>
                                                <td>
                                                    <a href=\"{{ path('app_admin_booking_edit', {id: booking.id}) }}\" class=\"btn-table-action\">Edit</a>
                                                </td>
                                            </tr>
                                        {% endfor %}
                                    </tbody>
                                </table>
                            </div>
                        {% else %}
                            <p class=\"no-data\">No bookings yet.</p>
                        {% endif %}
                    </div>

                    <div class=\"admin-section\">
                        <div class=\"section-header\">
                            <h2>Quick Actions</h2>
                        </div>
                        <div class=\"quick-actions\">
                            <a href=\"{{ path('app_admin_booking_new') }}\" class=\"quick-action-card\">
                                <span class=\"action-icon\">➕</span>
                                <h3>Create Booking</h3>
                                <p>Add a new customer booking</p>
                            </a>
                            <a href=\"{{ path('app_admin_service_provider_new') }}\" class=\"quick-action-card\">
                                <span class=\"action-icon\">👤</span>
                                <h3>Add Provider</h3>
                                <p>Register new service provider</p>
                            </a>
                            <a href=\"{{ path('app_admin_bookings') }}\" class=\"quick-action-card\">
                                <span class=\"action-icon\">📊</span>
                                <h3>View Reports</h3>
                                <p>See all bookings and earnings</p>
                            </a>
                        </div>
                    </div>
                </main>
            </div>
        </div>
    </section>
{% endblock %}
", "admin/dashboard.html.twig", "/Users/tomasstejskal/homewifes/templates/admin/dashboard.html.twig");
    }
}
