<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* admin/bookings/list.html.twig */
class __TwigTemplate_360a2e67cacb0838226b4a7be42efeb2 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'title' => [$this, 'block_title'],
            'body' => [$this, 'block_body'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 1
        return "base.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "admin/bookings/list.html.twig"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "admin/bookings/list.html.twig"));

        $this->parent = $this->load("base.html.twig", 1);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_title(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "title"));

        yield "Manage Bookings - Admin";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    // line 5
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_body(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_5a27a8ba21ca79b61932376b2fa922d2 = $this->extensions["Symfony\\Bundle\\WebProfilerBundle\\Twig\\WebProfilerExtension"];
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->enter($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "body"));

        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "body"));

        // line 6
        yield "    <section class=\"admin-header\">
        <div class=\"container\">
            <div class=\"admin-header-content\">
                <div>
                    <h1>All Bookings</h1>
                    <p>Manage and monitor all customer bookings</p>
                </div>
                <div class=\"admin-header-actions\">
                    <a href=\"";
        // line 14
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_booking_new");
        yield "\" class=\"btn btn-primary\">+ New Booking</a>
                    <a href=\"";
        // line 15
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_dashboard");
        yield "\" class=\"btn btn-secondary\">Dashboard</a>
                </div>
            </div>
        </div>
    </section>

    <section class=\"admin-content\">
        <div class=\"container\">
            <div class=\"admin-grid\">
                <aside class=\"admin-sidebar\">
                    <nav class=\"admin-nav\">
                        <a href=\"";
        // line 26
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_dashboard");
        yield "\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">📊</span>
                            Dashboard
                        </a>
                        <a href=\"";
        // line 30
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_bookings");
        yield "\" class=\"admin-nav-item active\">
                            <span class=\"nav-icon\">📅</span>
                            All Bookings
                        </a>
                        <a href=\"";
        // line 34
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_service_providers");
        yield "\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">👥</span>
                            Service Providers
                        </a>
                    </nav>
                </aside>

                <main class=\"admin-main\">
                    <div class=\"admin-section\">
                        <div class=\"section-header\">
                            <h2>All Bookings (";
        // line 44
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, (isset($context["bookings"]) || array_key_exists("bookings", $context) ? $context["bookings"] : (function () { throw new RuntimeError('Variable "bookings" does not exist.', 44, $this->source); })()), "getTotalItemCount", [], "any", false, false, false, 44), "html", null, true);
        yield ")</h2>
                        </div>

                        ";
        // line 47
        if ((CoreExtension::getAttribute($this->env, $this->source, (isset($context["bookings"]) || array_key_exists("bookings", $context) ? $context["bookings"] : (function () { throw new RuntimeError('Variable "bookings" does not exist.', 47, $this->source); })()), "getTotalItemCount", [], "any", false, false, false, 47) > 0)) {
            // line 48
            yield "                            <div class=\"bookings-table\">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Date & Time</th>
                                            <th>Customer</th>
                                            <th>Contact</th>
                                            <th>Provider</th>
                                            <th>Service</th>
                                            <th>Hours</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Booked On</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        ";
            // line 66
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable((isset($context["bookings"]) || array_key_exists("bookings", $context) ? $context["bookings"] : (function () { throw new RuntimeError('Variable "bookings" does not exist.', 66, $this->source); })()));
            foreach ($context['_seq'] as $context["_key"] => $context["booking"]) {
                // line 67
                yield "                                            <tr>
                                                <td><strong>#";
                // line 68
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "id", [], "any", false, false, false, 68), "html", null, true);
                yield "</strong></td>
                                                <td>
                                                    ";
                // line 70
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "serviceDate", [], "any", false, false, false, 70), "M d, Y"), "html", null, true);
                yield "<br>
                                                    <small>";
                // line 71
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "serviceTime", [], "any", false, false, false, 71), "g:i A"), "html", null, true);
                yield "</small>
                                                </td>
                                                <td>";
                // line 73
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "customerName", [], "any", false, false, false, 73), "html", null, true);
                yield "</td>
                                                <td>
                                                    <small>";
                // line 75
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "customerEmail", [], "any", false, false, false, 75), "html", null, true);
                yield "</small><br>
                                                    <small>";
                // line 76
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "customerPhone", [], "any", false, false, false, 76), "html", null, true);
                yield "</small>
                                                </td>
                                                <td>";
                // line 78
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "serviceProvider", [], "any", false, false, false, 78), "user", [], "any", false, false, false, 78), "fullName", [], "any", false, false, false, 78), "html", null, true);
                yield "</td>
                                                <td>";
                // line 79
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "service", [], "any", false, false, false, 79), "name", [], "any", false, false, false, 79), "html", null, true);
                yield "</td>
                                                <td>";
                // line 80
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "hours", [], "any", false, false, false, 80), "html", null, true);
                yield "h</td>
                                                <td><strong>\$";
                // line 81
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "totalPrice", [], "any", false, false, false, 81), "html", null, true);
                yield "</strong></td>
                                                <td>
                                                    <span class=\"badge badge-";
                // line 83
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "status", [], "any", false, false, false, 83), "html", null, true);
                yield "\">
                                                        ";
                // line 84
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::titleCase($this->env->getCharset(), CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "status", [], "any", false, false, false, 84)), "html", null, true);
                yield "
                                                    </span>
                                                </td>
                                                <td><small>";
                // line 87
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Twig\Extension\CoreExtension']->formatDate(CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "createdAt", [], "any", false, false, false, 87), "M d, Y"), "html", null, true);
                yield "</small></td>
                                                <td>
                                                    <div class=\"table-actions\">
                                                        <a href=\"";
                // line 90
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_booking_edit", ["id" => CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "id", [], "any", false, false, false, 90)]), "html", null, true);
                yield "\" 
                                                           class=\"btn-table-action\">Edit</a>
                                                        <form method=\"post\" 
                                                              action=\"";
                // line 93
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_booking_delete", ["id" => CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "id", [], "any", false, false, false, 93)]), "html", null, true);
                yield "\" 
                                                              style=\"display: inline;\"
                                                              onsubmit=\"return confirm('Are you sure you want to delete this booking?');\">
                                                            <input type=\"hidden\" name=\"_token\" value=\"";
                // line 96
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->env->getRuntime('Symfony\Component\Form\FormRenderer')->renderCsrfToken(("delete" . CoreExtension::getAttribute($this->env, $this->source, $context["booking"], "id", [], "any", false, false, false, 96))), "html", null, true);
                yield "\">
                                                            <button type=\"submit\" class=\"btn-table-action btn-danger\">Delete</button>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['booking'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 103
            yield "                                    </tbody>
                                </table>
                            </div>

                            ";
            // line 108
            yield "                            <div class=\"pagination-wrapper\">
                                ";
            // line 109
            yield $this->env->getRuntime('Knp\Bundle\PaginatorBundle\Twig\Extension\PaginationRuntime')->render($this->env, (isset($context["bookings"]) || array_key_exists("bookings", $context) ? $context["bookings"] : (function () { throw new RuntimeError('Variable "bookings" does not exist.', 109, $this->source); })()));
            yield "
                            </div>
                        ";
        } else {
            // line 112
            yield "                            <div class=\"no-bookings-state\">
                                <div class=\"empty-icon\">📅</div>
                                <h3>No Bookings Yet</h3>
                                <p>No customer bookings have been created yet.</p>
                                <a href=\"";
            // line 116
            yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("app_admin_booking_new");
            yield "\" class=\"btn btn-primary\">+ Create First Booking</a>
                            </div>
                        ";
        }
        // line 119
        yield "                    </div>
                </main>
            </div>
        </div>
    </section>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        
        $__internal_5a27a8ba21ca79b61932376b2fa922d2->leave($__internal_5a27a8ba21ca79b61932376b2fa922d2_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "admin/bookings/list.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  303 => 119,  297 => 116,  291 => 112,  285 => 109,  282 => 108,  276 => 103,  263 => 96,  257 => 93,  251 => 90,  245 => 87,  239 => 84,  235 => 83,  230 => 81,  226 => 80,  222 => 79,  218 => 78,  213 => 76,  209 => 75,  204 => 73,  199 => 71,  195 => 70,  190 => 68,  187 => 67,  183 => 66,  163 => 48,  161 => 47,  155 => 44,  142 => 34,  135 => 30,  128 => 26,  114 => 15,  110 => 14,  100 => 6,  87 => 5,  64 => 3,  41 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% extends 'base.html.twig' %}

{% block title %}Manage Bookings - Admin{% endblock %}

{% block body %}
    <section class=\"admin-header\">
        <div class=\"container\">
            <div class=\"admin-header-content\">
                <div>
                    <h1>All Bookings</h1>
                    <p>Manage and monitor all customer bookings</p>
                </div>
                <div class=\"admin-header-actions\">
                    <a href=\"{{ path('app_admin_booking_new') }}\" class=\"btn btn-primary\">+ New Booking</a>
                    <a href=\"{{ path('app_admin_dashboard') }}\" class=\"btn btn-secondary\">Dashboard</a>
                </div>
            </div>
        </div>
    </section>

    <section class=\"admin-content\">
        <div class=\"container\">
            <div class=\"admin-grid\">
                <aside class=\"admin-sidebar\">
                    <nav class=\"admin-nav\">
                        <a href=\"{{ path('app_admin_dashboard') }}\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">📊</span>
                            Dashboard
                        </a>
                        <a href=\"{{ path('app_admin_bookings') }}\" class=\"admin-nav-item active\">
                            <span class=\"nav-icon\">📅</span>
                            All Bookings
                        </a>
                        <a href=\"{{ path('app_admin_service_providers') }}\" class=\"admin-nav-item\">
                            <span class=\"nav-icon\">👥</span>
                            Service Providers
                        </a>
                    </nav>
                </aside>

                <main class=\"admin-main\">
                    <div class=\"admin-section\">
                        <div class=\"section-header\">
                            <h2>All Bookings ({{ bookings.getTotalItemCount }})</h2>
                        </div>

                        {% if bookings.getTotalItemCount > 0 %}
                            <div class=\"bookings-table\">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Date & Time</th>
                                            <th>Customer</th>
                                            <th>Contact</th>
                                            <th>Provider</th>
                                            <th>Service</th>
                                            <th>Hours</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Booked On</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {% for booking in bookings %}
                                            <tr>
                                                <td><strong>#{{ booking.id }}</strong></td>
                                                <td>
                                                    {{ booking.serviceDate|date('M d, Y') }}<br>
                                                    <small>{{ booking.serviceTime|date('g:i A') }}</small>
                                                </td>
                                                <td>{{ booking.customerName }}</td>
                                                <td>
                                                    <small>{{ booking.customerEmail }}</small><br>
                                                    <small>{{ booking.customerPhone }}</small>
                                                </td>
                                                <td>{{ booking.serviceProvider.user.fullName }}</td>
                                                <td>{{ booking.service.name }}</td>
                                                <td>{{ booking.hours }}h</td>
                                                <td><strong>\${{ booking.totalPrice }}</strong></td>
                                                <td>
                                                    <span class=\"badge badge-{{ booking.status }}\">
                                                        {{ booking.status|title }}
                                                    </span>
                                                </td>
                                                <td><small>{{ booking.createdAt|date('M d, Y') }}</small></td>
                                                <td>
                                                    <div class=\"table-actions\">
                                                        <a href=\"{{ path('app_admin_booking_edit', {id: booking.id}) }}\" 
                                                           class=\"btn-table-action\">Edit</a>
                                                        <form method=\"post\" 
                                                              action=\"{{ path('app_admin_booking_delete', {id: booking.id}) }}\" 
                                                              style=\"display: inline;\"
                                                              onsubmit=\"return confirm('Are you sure you want to delete this booking?');\">
                                                            <input type=\"hidden\" name=\"_token\" value=\"{{ csrf_token('delete' ~ booking.id) }}\">
                                                            <button type=\"submit\" class=\"btn-table-action btn-danger\">Delete</button>
                                                        </form>
                                                    </div>
                                                </td>
                                            </tr>
                                        {% endfor %}
                                    </tbody>
                                </table>
                            </div>

                            {# Pagination controls #}
                            <div class=\"pagination-wrapper\">
                                {{ knp_pagination_render(bookings) }}
                            </div>
                        {% else %}
                            <div class=\"no-bookings-state\">
                                <div class=\"empty-icon\">📅</div>
                                <h3>No Bookings Yet</h3>
                                <p>No customer bookings have been created yet.</p>
                                <a href=\"{{ path('app_admin_booking_new') }}\" class=\"btn btn-primary\">+ Create First Booking</a>
                            </div>
                        {% endif %}
                    </div>
                </main>
            </div>
        </div>
    </section>
{% endblock %}
", "admin/bookings/list.html.twig", "/Users/tomasstejskal/homewifes/templates/admin/bookings/list.html.twig");
    }
}
